

<?php $__env->startSection('header-php'); ?>
  <?php
  $body_id = '';
  $body_class = '';
  ?>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('meta-dynamic'); ?>
  <title><?php echo e(config('app.name')); ?></title>  
  <meta name="description" content="-">    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Inventory | Create
    </h1>
    
    <!-- 
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
      <li class="active">Here</li>
    </ol> 
    -->

  </section>

  <!-- Main content -->
    <section class="content container-fluid">
        
        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        <?php if(Session::has('message')): ?>
            <div class="alert <?php echo e(Session::get('alert_class')); ?>">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              <?php echo e(Session::get('message')); ?>

            </div>
        <?php endif; ?>             

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">&times</button>
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>         
        
        <div class="box box-primary">

          <?php echo e(Form::open(array('url' => 'inventory/store', 'class' => ''))); ?>

            <div class="box-body">
              
              <div class="form-group">
                <label>Item Category <span class="required">*</span></label>
                <select name="item_id" class="form-control">
                  <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($i->id); ?>"><?php echo e($i->item_name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="form-group">
                <label>Inventory Date <span class="required">*</span></label>
                <?php echo Form::text('inventory_date', date("Y-m-d") ,['class' => 'form-control inventory-date', 'required' => '']); ?>
              </div>
              <div class="form-group">
                <label>In Quantity <span class="required">*</span></label>
                <?php echo Form::number('in', 0 ,['class' => 'form-control', 'required' => '']); ?>
              </div>   

              <div class="form-group">
                <label>Out Quantity <span class="required">*</span></label>
                <?php echo Form::number('out', 0 ,['class' => 'form-control', 'required' => '']); ?>
              </div>          
            <!-- /.box-body -->

            <div class="box-footer">
              <button type="submit" class="btn btn-success">Submit</button>
              <a class="btn btn-primary" href="<?php echo e(route('inventory')); ?>">Cancel</a>
            </div>
          <?php echo Form::close(); ?>     

        </div>        

    </section>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-footer-scripts'); ?>
<script>
  var base_url = '<?php echo url("/"); ?>'; 
  $(function(){
    $('.inventory-date').datepicker({
      autoclose: true,
      format: 'yyyy-mm-dd',
    });
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/efvyhdmy/public_html/inventory/resources/views/inventory/create.blade.php ENDPATH**/ ?>