

<?php $__env->startSection('header-php'); ?>
  <?php
  $body_id = '';
  $body_class = '';
  ?>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('meta-dynamic'); ?>
  <title><?php echo e(config('app.name')); ?></title>  
  <meta name="description" content="-">    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Inventory Management
    </h1>
    
    <!-- 
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
      <li class="active">Here</li>
    </ol> 
    -->

  </section>

  <!-- Main content -->
    <section class="content container-fluid">

        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        <?php if(Session::has('message')): ?>
            <div class="alert <?php echo e(Session::get('alert_class')); ?>">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              <?php echo e(Session::get('message')); ?>

            </div>
        <?php endif; ?>    
        
        <div class="row">
            <div class="col-md-12">
              <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">Inventory List</h3>
                    <div class="pull-right">
                        <a href="<?php echo e(route('inventory/create')); ?>" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Create New
                        </a>
                    </div>
                </div>
                <!-- /.box-header -->

                <div class="box-body">

                  <table class="table table-bordered table-hover">
                    <tr>
                      <th style="width: 1%;" >#</th>
                      <th style="width: 70%;">Item Name</th>
                      <th>Date</th>
                      <th>In</th>
                      <th>Out</th>
                      <th>Previous Stock</th>
                      <th>New Stock</th>
                    </tr>
                    <?php $__currentLoopData = $inventory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($i->id); ?></td>
                            <td><?php echo e($i->item->item_name); ?></td>
                            <td><?php echo e($i->inventory_date); ?></td>
                            <td><?php echo e(number_format($i->in, 0)); ?></td>
                            <td><?php echo e(number_format($i->out, 0)); ?></td>
                            <td><?php echo e(number_format($i->previous_stock, 0)); ?></td>
                            <td><?php echo e(number_format($i->new_stock, 0)); ?></td>
                        </tr>

                        <div id="modalDelete-<?= $i->id; ?>" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
                            <div class="modal-dialog modal-md">
                              <div class="modal-content">

                                <div class="modal-header">
                                  <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                                  </button>
                                  <h4 class="modal-title" id="myModalLabel">Delete</h4>
                                </div>
                                <div class="modal-body">
                                  Are you sure you want to delete selected inventory date?
                                </div>
                                <div class="modal-footer">
                                  <?php echo e(Form::open(array('url' => 'inventory/destroy'))); ?>

                                    <?php echo Form::hidden('id', Hashids::encode($i->id) ,[]); ?>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                    <button type="submit" class="btn btn-danger">Yes</button>
                                  <?php echo Form::close(); ?>

                                </div>

                              </div>
                            </div>
                        </div>   

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </table>

                </div>
                <!-- /.box-body -->

                <div style="text-align: center;" class="box-footer clearfix">
                    <?php echo e($inventory->links()); ?>

                </div>

              </div>
              <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

    </section>
  <!-- /.content -->
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/efvyhdmy/public_html/inventory/resources/views/inventory/index.blade.php ENDPATH**/ ?>